<!DOCTYPE html>
<html xmlns='http://www.w3.org/1999/xhtml' xml:lang='en' lang='en'>
<?php
	$l_s_time = microtime(TRUE);
	// user data
	$user_file = 'user/user.xml';
	$user_get = simplexml_load_file($user_file);
	$user_array = $user_get->xpath("/miter/user[@id='probe']");
	$user_name 			= $user_array[0]->name;
	$user_avatar 		= $user_array[0]->avatar;
	$user_bio 			= $user_array[0]->bio;
	$user_bg_top 		= $user_array[0]->bgtop;
	$user_bg_bot 		= $user_array[0]->bgbot;
	$user_header 		= $user_array[0]->header;
	$user_border 		= $user_array[0]->border;
	$user_header_text 	= $user_array[0]->headertext;
	$user_link 			= $user_array[0]->link;
	$user_side 			= $user_array[0]->side;
	$user_radius 		= $user_array[0]->radius;
	$user_width_miter 	= $user_array[0]->widthmiter;
	$user_width_panel 	= $user_array[0]->widthpanel;
	$user_pin 			= $user_array[0]->pin;
	// logged in
	session_start();
	$user_log_in = str_replace('@','',$user_name);
	if ($_SESSION['miter'] == $user_log_in) {
		$login = true;
	} else {
		$login = false;
	}
?>
<head>
	<meta charset='utf-8'>
	<meta name='viewport' content='initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no'>
	<meta name='robots' content='ALL,INDEX,FOLLOW,ARCHIVE'>
	<meta name='revisit-after' content='1 day'>
	<meta name='description' content='<?php echo $user_bio; ?>'>
	<link rel='icon' type='image/png' href='images/<?php echo $user_avatar; ?>'>
	<link rel='shortcut' type='image/png' href='images/<?php echo $user_avatar; ?>'>
	<link rel='alternate' type='application/atom+xml' href='front/atom.php'>
	<link rel='stylesheet' href='front/style.css'>
	<script src='https://ajax.aspnetcdn.com/ajax/jQuery/jquery-3.4.1.min.js'></script>
<?php
	// admin
	if ($login == true){
		echo "<link href='back/admin.css' rel='stylesheet'>";
		echo "<script src='back/js/delete.js'></script>";
	}
	// mobile or desktop
	function isMobile() {
		return preg_match("/(android|webos|avantgo|iphone|ipad|ipod|blackberry|iemobile|bolt|boost|cricket|docomo|fone|hiptop|mini|opera mini|kitkat|mobi|palm|phone|pie|tablet|up\.browser|up\.link|webos|wos)/i", $_SERVER["HTTP_USER_AGENT"]);
	}
	// count miters live
	$count_miters = glob('miters/*.txt');
	$miter_count = count($count_miters);
	// count tenons
	$count_tenons = glob('tenons/*.txt');
	$tenon_count = count($count_tenons);
?>
	<style><?php include 'front/style.php'; ?></style>
	<title><?php include 'front/title.php'; ?></title>
</head>
<?php 	if (isMobile()) { ?>
<body class='mobile'>
<table class='mobile_table'>
	<tr>
		<td class='mobile_content_td'>
			<?php include 'front/direct.php'; ?>
		</td>
	</tr>
	<tr>
		<td class='mobile_panel_td'>
			<?php include 'front/panels.php';
			if ($login == true) {
				include 'back/menu.php';
			} ?>
		</td>
	</tr>
</table>
 <?php	} else { ?>
<body class='desktop'>
<div align='center'>
<table class='desktop_table'>
	<tr>
	<?php if ($user_side == 'right') { ?>
		<td class='desktop_content_td_right'>
			<?php include 'front/direct.php'; ?>
		</td>
		<td class='desktop_panel_td'>
			<?php include 'front/panels.php';
			if ($login == true) {
				include 'back/menu.php';
			} ?>
		</td>
	<?php } else { ?>
		<td class='desktop_panel_td'>
			<?php include 'front/panels.php';
			if ($login == true) {
				include 'back/menu.php';
			} ?>
		</td>
		<td class='desktop_content_td_left'>
			<?php include 'front/direct.php'; ?>
		</td>
	<?php } ?>
	</tr>
</table>
</div>
<?php 	} ?>
</body>
</html>